// ################################################################################
//
//  Motor Test vB0
//
//  Released:  12/01/2025
//
//  Author: TechKnowTone
//
// ################################################################################
/*
    TERMS OF USE: This software is furnished "as is", without technical support, and
    with no warranty, expressed or implied, as to its usefulness for any purpose. In
    no event shall the author or copyright holder be liable for any claim, damages,
    or other liability, whether in an action of contract, tort or otherwise, arising
    from, out of or in connection with the software or the use or other dealings in
    the software.

    microcontroller: ESP32 Dev Module   v3.0.2

    This code was writtent to confirm the function of the H-Bridge drivers, for the
    Omni-Bot. Button switches SW0 and SW1 are used to turn all three motors ON and OFF.
    
    IMPORTANT - Espressif changed the way ESP-NOW works from v3.0, which broke the original
    code and caused compiler errors. This version has been modified to work with v3.0+.
    Enjoy!
*/
// Declare libraries

#define Released "15/09/2024"

// define constants
#define Pin_A0 33                   // PWM pin for motor A front
#define Pin_A1 32                   // PWM pin for motor A front
#define Pin_B0 26                   // PWM pin for motor B right
#define Pin_B1 25                   // PWM pin for motor B right
#define Pin_C0 13                   // PWM pin for motor C rear
#define Pin_C1 27                   // PWM pin for motor C rear
#define SW0_Pin 12                  // GPIO for switch SW0
#define SW1_Pin 15                  // GPIO for switch SW1

// Declare and initialise general global variables
bool SW0_Last = HIGH;         // previous state of SW0
bool SW0_State = HIGH;        // state read by the code
bool SW1_Last = HIGH;         // previous state of SW0
bool SW1_State = HIGH;        // state read by the code

// --------------------------------------------------------------------------------

void setup() {
  // Setup basic functions
  // Initialise H-bridge PWM pins and output states all LOW
  pinMode(Pin_A0, OUTPUT); digitalWrite(Pin_A0,LOW);
  pinMode(Pin_A1, OUTPUT); digitalWrite(Pin_A1,LOW);
  pinMode(Pin_B0, OUTPUT); digitalWrite(Pin_B0,LOW);
  pinMode(Pin_B1, OUTPUT); digitalWrite(Pin_B1,LOW);
  pinMode(Pin_C0, OUTPUT); digitalWrite(Pin_C0,LOW);
  pinMode(Pin_C1, OUTPUT); digitalWrite(Pin_C1,LOW);
  // Define switch inputs as pullups
  pinMode(SW0_Pin,INPUT_PULLUP);
  pinMode(SW1_Pin,INPUT_PULLUP);

  Serial.begin(115200); // use this baud rate
  delay(100);
}

// --------------------------------------------------------------------------------

void loop() {
  // This main loop runs continuously, on a 20ms cycle.
  // Holding down SW0 should turn the robot to the left, all wheels turning clockwise.
  // Holding down SW1 should turn the robot to the right, all wheels turning anti-clockwise.
  // Note that motors will turn at maximum speed.
  SW0_State = digitalRead(SW0_Pin);
  if (SW0_State != SW0_Last) {
    if (SW0_State) {
      Serial.println("SW0 Hi - motors OFF");
      Motors_Off();
    } else {
      Serial.println("SW0 Lo");
      digitalWrite(Pin_A1,HIGH);
      digitalWrite(Pin_B1,HIGH);
      digitalWrite(Pin_C1,HIGH);
    }
  }
  SW0_Last = SW0_State;

  SW1_State = digitalRead(SW1_Pin);
  if (SW1_State != SW1_Last) {
    if (SW1_State) {
      Serial.println("SW1 Hi - motors OFF");
      Motors_Off();
    } else {
      Serial.println("SW1 Lo");
      digitalWrite(Pin_A0,HIGH);
      digitalWrite(Pin_B0,HIGH);
      digitalWrite(Pin_C0,HIGH);
    }
  }
  SW1_Last = SW1_State;
  delay (20);
}

// --------------------------------------------------------------------------------

void Motors_Off() {
  // Set H-bridge drivers to high impedance state, by setting all inputs LOW
  digitalWrite(Pin_A0,LOW); digitalWrite(Pin_A1,LOW);
  digitalWrite(Pin_B0,LOW); digitalWrite(Pin_B1,LOW);
  digitalWrite(Pin_C0,LOW); digitalWrite(Pin_C1,LOW);
}

// --------------------------------------------------------------------------------
